#!/bin/sh

mkdir -p /build/x265_git-git/build/msys32_hdr10_ml

export CPPFLAGS="-D_FORTIFY_SOURCE=2 -D__USE_MINGW_ANSI_STDIO=1"
export CFLAGS="-fstack-protector-strong -mtune=generic -O2 -pipe -mthreads"
export CXXFLAGS="-fstack-protector-strong -mthreads -march=pentium4 -mtune=generic -O2 -pipe"
export LDFLAGS="-pipe -static-libgcc -fstack-protector-strong -static-libstdc++"

cd /build/x265_git-git/build/msys32_hdr10_ml/
mkdir -p 8bit 10bit 12bit

cd 12bit
make --no-print-directory clean-generated
cmake -G "MSYS Makefiles" ../../../source -DHG_EXECUTABLE=/usr/bin/hg.bat -DCMAKE_CXX_COMPILER=/local32/bin/g++.bat -DCMAKE_TOOLCHAIN_FILE=/local32/etc/toolchain.cmake -DWINXP_SUPPORT=OFF -DEXPORT_C_API=OFF -DENABLE_SHARED=OFF -DENABLE_CLI=OFF -DENABLE_ASSEMBLY=OFF -DHIGH_BIT_DEPTH=ON -DMAIN12=ON -DENABLE_HDR10_PLUS=ON -DENABLE_LIBVMAF=ON -DENABLE_ALPHA=ON -DENABLE_MULTIVIEW=ON -DENABLE_SCC_EXT=ON
make --no-print-directory ${MAKEFLAGS}
cp libx265.a ../8bit/libx265_main12.a

cd ../10bit
make --no-print-directory clean-generated
cmake -G "MSYS Makefiles" ../../../source -DHG_EXECUTABLE=/usr/bin/hg.bat -DCMAKE_CXX_COMPILER=/local32/bin/g++.bat -DCMAKE_TOOLCHAIN_FILE=/local32/etc/toolchain.cmake -DWINXP_SUPPORT=OFF -DEXPORT_C_API=OFF -DENABLE_SHARED=OFF -DENABLE_CLI=OFF -DENABLE_ASSEMBLY=OFF -DHIGH_BIT_DEPTH=ON -DMAIN12=OFF -DENABLE_HDR10_PLUS=ON -DENABLE_LIBVMAF=ON -DENABLE_ALPHA=ON -DENABLE_MULTIVIEW=ON -DENABLE_SCC_EXT=ON
make --no-print-directory ${MAKEFLAGS}
cp libx265.a ../8bit/libx265_main10.a

cd ../8bit
make --no-print-directory clean-generated
cmake -G "MSYS Makefiles" ../../../source -DHG_EXECUTABLE=/usr/bin/hg.bat -DCMAKE_CXX_COMPILER=/local32/bin/g++.bat -DCMAKE_TOOLCHAIN_FILE=/local32/etc/toolchain.cmake -DWINXP_SUPPORT=OFF -DEXPORT_C_API=ON -DENABLE_SHARED=ON -DENABLE_CLI=ON -DENABLE_ASSEMBLY=ON -DHIGH_BIT_DEPTH=OFF -DENABLE_HDR10_PLUS=ON -DENABLE_LIBVMAF=ON -DENABLE_ALPHA=ON -DENABLE_MULTIVIEW=ON -DENABLE_SCC_EXT=ON -DEXTRA_LIB="x265_main10.a;x265_main12.a" -DEXTRA_LINK_FLAGS=-L. -DLINKED_10BIT=ON -DLINKED_12BIT=ON
make --no-print-directory ${MAKEFLAGS}

# rename the 8bit library, then combine all three into libx265.a using GNU ar
mv libx265.a libx265_main.a

ar -M <<EOF
CREATE libx265.a
ADDLIB libx265_main.a
ADDLIB libx265_main10.a
ADDLIB libx265_main12.a
SAVE
END
EOF

/mingw32/bin/strip.exe --strip-unneeded libx265.dll
/mingw32/bin/strip.exe --strip-unneeded x265.exe
